import java.lang.*;
import java.util.*;
import java.io.*;

public class GeneticFiniteStates
{
	
	// DECIDE WHAT TO DO WITH ALL OF THESE CONSTANTS, SHOULD THEY BE CHANGEABLE?
	public static int NUM_MACHINES = 10;
	public static int NUM_MACHINES_TO_KEEP = 3;
	public static int NOTES_TO_PLAY = 10;
	
	Vector CurrentMachines = new Vector();
	
	public int whereAmI = 0;
	
	public static void main(String[] args)
	{

		GeneticFiniteStates gfs = new GeneticFiniteStates();
		
		while (true)
		{
			gfs.generateMachines();
			gfs.rankMachines();
			gfs.evolveMachines();
		}
		
		//System.exit(1);
	}

	GeneticFiniteStates()
	{
		//generateMachines();
	}

	public void outputMachines(Vector RankedMachines)
	{
		try
		{
			// Create the filename object
		        File fileFilename = new File("OutputFile.txt");
		
			// Check to see if it exists, if not create it.
		        if (!(fileFilename.exists()))
		        {
		                fileFilename.createNewFile();
		        }
		
		        // Open output stream to the file in append mode
		        FileWriter fwFilename = new FileWriter(fileFilename.getName(), true);
		
		        // Buffer the output stream
		        PrintWriter pwFilename = new PrintWriter(fwFilename);
		
			// Output to the filename
			for (int i = 0; i < RankedMachines.size(); i++)
			{
				pwFilename.println( ((FiniteStateMusicMachine) ((RankedMachine) RankedMachines.elementAt(i)).returnMachine()).toString() + " " + ((RankedMachine) RankedMachines.elementAt(i)).returnRank().toString() );
				System.out.println( ((FiniteStateMusicMachine) ((RankedMachine) RankedMachines.elementAt(i)).returnMachine()).toString() + " " + ((RankedMachine) RankedMachines.elementAt(i)).returnRank().toString() );
				
			}
			pwFilename.println();
	
		        // Close the output stream
		        fwFilename.close();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}

	public void rankMachines()
	{
		Vector RankedMachines = new Vector();

		for (int i = 0; i < CurrentMachines.size(); i++)
		{
			System.out.println(whereAmI++);
			System.out.println(((FiniteStateMusicMachine) CurrentMachines.elementAt(i)).toString() + "\n" + ((FiniteStateMusicMachine) CurrentMachines.elementAt(i)).playMachine(NOTES_TO_PLAY));

			try {

					// Take in the input strings
					InputStreamReader isrIn = new InputStreamReader(System.in);
					BufferedReader brIn = new BufferedReader(isrIn);

					// Prompt user to input First Name at command prompt
					System.out.print("Rank this from 0 to 9, (0 being best): ");

					// Turn input into a string
					Integer machineRank = new Integer(brIn.readLine());
					
					((FiniteStateMusicMachine) CurrentMachines.elementAt(i)).stopMachine();
					
					RankedMachines.add(new RankedMachine(machineRank, (FiniteStateMusicMachine) CurrentMachines.elementAt(i)));

			}
			// Catch any and all exceptions
			catch (Exception e)
			{
					System.out.println(e.toString());
					System.exit(0);
			}

		}
		outputMachines(RankedMachines);
		sortRankedMachines(RankedMachines);

	}

	public FiniteStateMusicMachine crossover(FiniteStateMusicMachine machineOne, FiniteStateMusicMachine machineTwo)
	{
		Random theRanGen = new Random();
		int whichFirst = theRanGen.nextInt(2);
		int crossoverPoint = theRanGen.nextInt(machineOne.toString().length() - 1);
		crossoverPoint = crossoverPoint + 1; // Can not be zero, zero is the machineObject size
		FiniteStateMusicMachine newMachine;
		if (whichFirst == 0)
		{
			newMachine = new FiniteStateMusicMachine(machineOne.toString().substring(0,crossoverPoint) + machineTwo.toString().substring(crossoverPoint,machineTwo.toString().length()));
		}
		else
		{
			newMachine = new FiniteStateMusicMachine(machineTwo.toString().substring(0,crossoverPoint) + machineOne.toString().substring(crossoverPoint,machineTwo.toString().length()));
		}
		return newMachine;
	}

	public FiniteStateMusicMachine mutate(FiniteStateMusicMachine theMachine)
	{
		Random theRanGen = new Random();
		int mutationPoint = theRanGen.nextInt(theMachine.toString().length() - 1);
		mutationPoint = mutationPoint + 1; // Can not be zero, zero is the machineObject size
		int theMutation = theRanGen.nextInt(10);
		FiniteStateMusicMachine newMachine;
		if (mutationPoint == 0)
		{
			newMachine = new FiniteStateMusicMachine(new Integer(theMutation).toString() + theMachine.toString().substring(mutationPoint + 1, theMachine.toString().length()));
		}
		else
		{
			newMachine = new FiniteStateMusicMachine(theMachine.toString().substring(0,mutationPoint) + theMutation + theMachine.toString().substring(mutationPoint + 1, theMachine.toString().length()));
		}
		return newMachine;
	}

	public void evolveMachines()
	{
		Vector NewMachines = new Vector();
		
		for (int i = 0; i < GeneticFiniteStates.NUM_MACHINES_TO_KEEP; i++)
		{
			if (i == 0)
			{
				NewMachines.add((FiniteStateMusicMachine) CurrentMachines.elementAt(i));
				NewMachines.add(mutate((FiniteStateMusicMachine) CurrentMachines.elementAt(i)));
			}
			else
			{
				NewMachines.add(crossover((FiniteStateMusicMachine) CurrentMachines.elementAt(0), (FiniteStateMusicMachine) CurrentMachines.elementAt(i)));
				if (i > 1)
				{
					NewMachines.add(crossover((FiniteStateMusicMachine) CurrentMachines.elementAt(i-1), (FiniteStateMusicMachine) CurrentMachines.elementAt(i)));
				}
			}
		}
		CurrentMachines.removeAllElements();
		CurrentMachines.addAll(NewMachines);
	}

	private void sortRankedMachines(Vector RankedMachines)
	{
		Vector TempHolder = new Vector();
		for (int i = 0; i < RankedMachines.size(); i++)
		{
			boolean isInserted = false;
			for (int q = 0; q < TempHolder.size(); q++)
			{
				if ((((RankedMachine) RankedMachines.elementAt(i)).returnRank().intValue() < ((RankedMachine) TempHolder.elementAt(q)).returnRank().intValue()) && !(isInserted))
				{
					TempHolder.add(q,((RankedMachine) RankedMachines.elementAt(i)));
					isInserted = true;
				}
			}
			if (!(isInserted))
			{
				TempHolder.add(TempHolder.size(),((RankedMachine) RankedMachines.elementAt(i)));
			}
		}
		CurrentMachines.removeAllElements();
		for (int i = 0; i < TempHolder.size(); i++)
		{
			CurrentMachines.add(((RankedMachine) TempHolder.elementAt(i)).returnMachine());
		}				
	}

	public void generateMachines()
	{
		Random theRanGen = new Random();

		// 10 Machines
		for (int i = CurrentMachines.size(); i < GeneticFiniteStates.NUM_MACHINES; i++)
		{
	
			StringBuffer theRanString = new StringBuffer();
			theRanString.append(FiniteStateMusicMachine.MACHINE_OBJECT_LENGTH);

			// Num Objects per machine
			for (int q = 0; q < FiniteStateMusicMachine.NUM_OBJECTS_MACHINE; q++)
			{
				// Object Length
				for (int p = 0; p < FiniteStateMusicMachine.MACHINE_OBJECT_LENGTH; p++)
				{
					theRanString.append(theRanGen.nextInt(10));
				}

			}

			System.out.println(theRanString.toString());
			FiniteStateMusicMachine theMachine = new FiniteStateMusicMachine(theRanString.toString());

			CurrentMachines.add(theMachine);

		}
		System.out.println();
	}
	
	private class RankedMachine
	{
		private Integer rankNumber;
		private FiniteStateMusicMachine machineObject;
		
		RankedMachine(Integer theRankNumber, FiniteStateMusicMachine theMachine)
		{
			rankNumber = theRankNumber;
			machineObject = theMachine;
		}
		
		public Integer returnRank()
		{
			return rankNumber;
		}
		
		public FiniteStateMusicMachine returnMachine()
		{
			return machineObject;
		}
	}
}
